#!/usr/bin/env python
"""
Automatyzowanie domu: wysyłanie e-maili za pomocą pilota bezprzewodowego 
Projekt na Raspberry Pi
"""

import os, glob, time, operator
import RPi.GPIO as GPIO
import time
import sys
import smtplib
from email.mime.text import MIMEText
from email.mime.application import MIMEApplication
from email.mime.multipart import MIMEMultipart
from time import gmtime, strftime

    
def get_latest_photo(files):
    lt = operator.lt
    if not files:
            return None
    now = time.time()
    latest = files[0], now - os.path.getctime(files[0])
    for f in files[1:]:
            age = now - os.path.getctime(f)
            if lt(age, latest[1]):
                    latest = f, age
    return latest[0]

def emailphoto(msgtext, afilename):
        # W cudzysłowiu umieść nazwę konta e-mail
        smtp_user = ""
        
        # W cudzysłowiu umieść hasło do konta e-mail
        smtp_pass = "" 
        msg = MIMEMultipart() 
        
        # W cudzysłowiu umieść docelowy adres e-mail
        msg['To']   = "" 
        
        # W cudzysłowiu umieść nazwę konta e-mail 
        msg['From'] = "" 
        
        # W cudzysłowiu umieść temat wiadomości
        msg['Subject'] = "" 
        
        # Tę informację zobaczy użytkownik, który nie ma klienta poczty elektronicznej    
        msg.preamble = 'Wieloczęściowa wiadomość.\n'  
        
        # sys.argv[1] to pierwszy parametr przekazywany do programu.
        # Parametr ten zawiera tekst wiadomości e-mail
        part = MIMEText(msgtext) 
        msg.attach(part)
        
        # Trzy poniższe wiersze dołączają zdjęcie z pliku, którego
        # nazwę przekazano jako drugi parametr programu
        part = MIMEApplication(open(afilename,"rb").read())
        part.add_header('Content-Disposition', 'attachment', filename=afilename)
        msg.attach(part)
        
        # Między cudzysłowami podaj adres URL lub IP serwera SMTP
        s = smtplib.SMTP_SSL("", 465) 
        s.login(smtp_user,smtp_pass)
        s.sendmail(msg['From'], msg['To'], msg.as_string())
        s.quit()

def sendreport():     
        msgtext = "Raport na temat stanu czujników z: " + strftime("%Y-%m-%d %H:%M:%S", gmtime()) + "\n"
        
        if GPIO.input(13) == True:  
                msgtext = msgtext + "Stan wyłącznika drzwiowego: drzwi otwarte\n"
        else:
                msgtext = msgtext + "Stan wyłącznika drzwiowego: drzwi zamknięte\n"
                        
                
        if GPIO.input(15) == True: 
                msgtext = msgtext + "Stan czujnika ruchu: brak ruchu\n"
        else:
                msgtext = msgtext + "Stan czujnika ruchu: wykryto ruch\n"
                
        # Wykorzystanie funkcji GetTemperature z projektu
        # dotyczącego pomiaru temperatury
        Temperature = GetTemperature() 
        msgtext = msgtext + "Temperatura wynosi: "+str(Temperature)+"\n"
        
        # Zmień tę ścieżkę na katalog, w którym 
        # przechowujesz zdjęcia z kamery internetowej.
        # Zapis *.jpg oznacza wszystkie pliki JPEG
        photopath = "/home/*.jpg" 
        files = glob.glob(photopath)
        latestphoto = get_latest_photo(files)
        msgtext = msgtext + 'Najnowsze zdjęcie:' + latestphoto + " znajdziesz w załączniku do wiadomości\n";
        
        # Wysyłanie wiadomości za pomocą funkcji emailphoto()
        # napisanej w projekcie dotyczącym e-maili
        emailphoto(msgtext, latestphoto) 
        print "Report został wysłany."


# Główna funkcja
def main():
        GPIO.setmode(GPIO.BOARD)  
        GPIO.setup(16, GPIO.IN) # Zdalny odbiornik RF
        GPIO.setup(13, GPIO.IN) # Wyłącznik drzwiowy
        GPIO.setup(15, GPIO.IN) # Czujnik ruchu
        
        rfkey = False
        
        while True:
                if GPIO.input(16) == False: # Wciśnięto przycisk w breloku
                        if rfkey == False:
                                rfkey = True
                                sendreport()
                else:
                        rfkey = False
                
                time.sleep(.3)
                
if __name__ == "__main__":
        main()
